%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: plot_par_corr_n2o
%
% Scope:    plot overview figure parameter correction (concentrations)
%
% Input:    data (structure),
%           bindata (structure),
%           binref (structure),
%           list of gas names (cell),
%           index of parameter used for correction (double),
%           index of "target" variables that are being corrected (double),
%           slope of linear fit (double)
%           intercept of linear fit (double)
%           index of anchor gas (double)
%           plot title (string)
%
% Output:   overview figure parameter correction (concentrations)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_par_corr_n2o(data,bindata,binref,gasnames,bindata_idx,target_idx,slope_n2o,intercept_n2o,ind_anchor,titlename)

    figure;
    subplot(1,2,1);
    hold on;
    for i=1:width(gasnames)
    scatter(bindata.(gasnames{1,i})(:,1),bindata.(gasnames{1,i})(:,target_idx),10);
    end
    errorbar(binref.mean(:,1),binref.mean(:,target_idx),binref.std(:,target_idx),'marker','o','linestyle','none','color','k','markeredgecolor','k','markerfacecolor','none','linewidth',1.2);
    grid on;
    box on;
    xlim([0 data.all(end,1)-bindata.start_time]);
    xlabel('Time [h]','fontsize',12);
    ylabel({sprintf('%s',bindata.varlabels{1,target_idx})},'fontsize',12);
    title({sprintf('%s',titlename)});
    lll=cell(1,width(gasnames));
    for n=1:width(gasnames)
        lll{n} = string(gasnames{1,n}); end
    legend(lll,'location','northeast');
   
    subplot(1,2,2);
    scatter(bindata.(gasnames{1,ind_anchor})(:,bindata_idx),bindata.(gasnames{1,ind_anchor})(:,target_idx));
    hold on;
    plot([min(bindata.(gasnames{1,ind_anchor})(:,bindata_idx)) max(bindata.(gasnames{1,ind_anchor})(:,bindata_idx))],slope_n2o(1,1)*[min(bindata.(gasnames{1,ind_anchor})(:,bindata_idx)) max(bindata.(gasnames{1,ind_anchor})(:,bindata_idx))]+intercept_n2o(1,1),'-r');
    yline(binref.(gasnames{1,ind_anchor})(1,target_idx),'--k');
    xline(binref.(gasnames{1,ind_anchor})(1,bindata_idx),'--k');
    grid on;
    box on;
    xlabel({sprintf('%s',bindata.varlabels{1,bindata_idx})},'fontsize',12);
    ylabel({sprintf('%s',bindata.varlabels{1,target_idx})},'fontsize',12);
    legend(string(gasnames{1,ind_anchor}),'linear fit','fontsize',10);

    x0 = 10;
    y0 = 150;
    ww = 900;
    hh = 400;
    set(gcf,'units','points','position',[x0,y0,ww,hh]);
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3),pos(4)]);
    
    %calculate r^2
    yy = bindata.(gasnames{1,ind_anchor})(:,target_idx);
    yy_calc = slope_n2o(1,1)*bindata.(gasnames{1,ind_anchor})(:,bindata_idx)+intercept_n2o(1,1);
    rsquared = 1 - sum((yy - yy_calc).^2)/sum((yy - mean(yy)).^2);
    XL = get(gca, 'XLim');
    YL = get(gca, 'YLim');
    text(XL(1,1)+0.02*(XL(1,2)-XL(1,1)),YL(1,1)+0.92*(YL(1,2)-YL(1,1)),['{\itR^2} = ', sprintf('%1.3f',rsquared) ],'color','r');

end

